/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import qouteall.imm_ptl.peripheral.CommandStickItem;
import qouteall.imm_ptl.peripheral.alternate_dimension.AlternateDimensions;
import qouteall.imm_ptl.peripheral.alternate_dimension.ChaosBiomeSource;
import qouteall.imm_ptl.peripheral.alternate_dimension.ErrorTerrainGenerator;
import qouteall.imm_ptl.peripheral.alternate_dimension.FormulaGenerator;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackManagement;
import qouteall.imm_ptl.peripheral.portal_generation.IntrinsicPortalGeneration;
import qouteall.imm_ptl.peripheral.wand.PortalWandItem;

public class PeripheralModMain {
    private static final DeferredRegister<Codec<? extends ChunkGenerator>> CHUNK_GENERATOR = DeferredRegister.create((ResourceKey)BuiltInRegistries.f_256914_.m_123023_(), (String)"immersive_portals");
    private static final DeferredRegister<Codec<? extends BiomeSource>> BIOME_SOURCE = DeferredRegister.create((ResourceKey)BuiltInRegistries.f_256737_.m_123023_(), (String)"immersive_portals");
    public static final RegistryObject<Codec<? extends ChunkGenerator>> ERROR_TERRAIN_GENERATOR = CHUNK_GENERATOR.register("error_terrain_generator", () -> ErrorTerrainGenerator.codec);
    public static final RegistryObject<Codec<? extends ChunkGenerator>> NORMAL_SKYLAND_GENERATOR = CHUNK_GENERATOR.register("normal_skyland_generator", () -> ErrorTerrainGenerator.codec);
    public static final RegistryObject<Codec<? extends BiomeSource>> CHAOS_BIOME_SOURCE = BIOME_SOURCE.register("chaos_biome_source", () -> ChaosBiomeSource.CODEC);

    @OnlyIn(value=Dist.CLIENT)
    public static void initClient() {
        PortalWandItem.initClient();
    }

    public static void init() {
        FormulaGenerator.init();
        IntrinsicPortalGeneration.init();
        DimStackManagement.init();
        AlternateDimensions.init();
    }

    public static void registerCommandStickTypes() {
        CommandStickItem.registerType("imm_ptl:rotate_around_view", new CommandStickItem.Data("execute positioned 0.0 0.0 0.0 run portal animation rotate_infinitely @p ^0.0 ^0.0 ^1.0 1.7", "imm_ptl.command.rotate_around_view", Lists.newArrayList((Object[])new String[]{"imm_ptl.command_dest.rotate_around_view"}), true));
        PeripheralModMain.registerPortalSubCommandStick("expand_from_center", "animation expand_from_center 20");
        PeripheralModMain.registerPortalSubCommandStick("clear_animation", "animation clear");
        CommandStickItem.registerType("imm_ptl:reset_scale", new CommandStickItem.Data("/scale set pehkui:base 1", "imm_ptl.command.reset_scale", Lists.newArrayList((Object[])new String[]{"imm_ptl.command_desc.reset_scale"}), true));
        CommandStickItem.registerType("imm_ptl:long_reach", new CommandStickItem.Data("/scale set pehkui:reach 5", "imm_ptl.command.long_reach", Lists.newArrayList((Object[])new String[]{"imm_ptl.command_desc.long_reach"}), true));
        CommandStickItem.registerType("imm_ptl:night_vision", new CommandStickItem.Data("/effect give @s minecraft:night_vision 9999 1 true", "imm_ptl.command.night_vision", List.of(), true));
    }

    private static void registerPortalSubCommandStick(String name) {
        PeripheralModMain.registerPortalSubCommandStick(name, name);
    }

    private static void registerPortalSubCommandStick(String name, String subCommand) {
        CommandStickItem.registerType("imm_ptl:" + name, new CommandStickItem.Data("/portal " + subCommand, "imm_ptl.command." + name, Lists.newArrayList((Object[])new String[]{"imm_ptl.command_desc." + name}), true));
    }
}

